-- --------------------------------------------------------
-- Host:                         127.0.0.1
-- Server version:               10.4.28-MariaDB - mariadb.org binary distribution
-- Server OS:                    Win64
-- HeidiSQL Version:             12.5.0.6677
-- --------------------------------------------------------

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET NAMES utf8 */;
/*!50503 SET NAMES utf8mb4 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

-- Dumping structure for table wikidatabase.articals
CREATE TABLE IF NOT EXISTS `articals` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` int(10) unsigned NOT NULL,
  `categories` text NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `sections` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_articals_topic_id` (`topic_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table wikidatabase.articals: ~0 rows (approximately)
INSERT INTO `articals` (`id`, `topic_id`, `categories`, `name`, `description`, `sections`) VALUES
	(1, 1, '{"categories": [1]}', 'Test-Artical', 'This post is for testing purposes to get everything up and ready.', '{"sections": [1, 2]}');

-- Dumping structure for table wikidatabase.artical_sections
CREATE TABLE IF NOT EXISTS `artical_sections` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` int(10) unsigned NOT NULL,
  `title` varchar(255) NOT NULL,
  `body` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_sections_topic_id` (`topic_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table wikidatabase.artical_sections: ~2 rows (approximately)
INSERT INTO `artical_sections` (`id`, `topic_id`, `title`, `body`) VALUES
	(1, 1, 'Test 1', '<p>This is a cool test thing</p>'),
	(2, 1, 'Test 2', 'Click this link to listen to one of Mac Demarco songs called "<a href="https://www.youtube.com/watch?v=cZCm_i6YvAk">For the first time</a>"');

-- Dumping structure for table wikidatabase.categories
CREATE TABLE IF NOT EXISTS `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `topic_id` int(10) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `fk_categories_topic_id` (`topic_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table wikidatabase.categories: ~0 rows (approximately)
INSERT INTO `categories` (`id`, `topic_id`, `name`, `description`) VALUES
	(1, 1, 'Miscellaneous', 'If a post doesn\'t have a specific category, then it goes here.');

-- Dumping structure for view wikidatabase.get_articals
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `get_articals` (
	`id` INT(10) UNSIGNED NOT NULL,
	`topic_id` INT(10) UNSIGNED NOT NULL,
	`categories` TEXT NOT NULL COLLATE 'utf8mb4_unicode_ci',
	`name` VARCHAR(255) NOT NULL COLLATE 'utf8mb4_unicode_ci',
	`description` TEXT NOT NULL COLLATE 'utf8mb4_unicode_ci',
	`sections` TEXT NULL COLLATE 'utf8mb4_unicode_ci'
) ENGINE=MyISAM;

-- Dumping structure for view wikidatabase.get_categories
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `get_categories` (
	`id` INT(10) UNSIGNED NOT NULL,
	`topic_id` INT(10) UNSIGNED NOT NULL,
	`name` VARCHAR(255) NOT NULL COLLATE 'utf8mb4_unicode_ci',
	`description` TEXT NOT NULL COLLATE 'utf8mb4_unicode_ci'
) ENGINE=MyISAM;

-- Dumping structure for view wikidatabase.get_sections
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `get_sections` (
	`id` INT(10) UNSIGNED NOT NULL,
	`topic_id` INT(10) UNSIGNED NOT NULL,
	`title` VARCHAR(255) NOT NULL COLLATE 'utf8mb4_unicode_ci',
	`body` TEXT NULL COLLATE 'utf8mb4_unicode_ci'
) ENGINE=MyISAM;

-- Dumping structure for view wikidatabase.get_topics
-- Creating temporary table to overcome VIEW dependency errors
CREATE TABLE `get_topics` (
	`id` INT(10) UNSIGNED NOT NULL,
	`name` VARCHAR(255) NOT NULL COLLATE 'utf8mb4_unicode_ci',
	`description` TEXT NOT NULL COLLATE 'utf8mb4_unicode_ci'
) ENGINE=MyISAM;

-- Dumping structure for table wikidatabase.topics
CREATE TABLE IF NOT EXISTS `topics` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- Dumping data for table wikidatabase.topics: ~0 rows (approximately)
INSERT INTO `topics` (`id`, `name`, `description`) VALUES
	(1, 'Test-Topic', 'This topic is for testing purposes.');

-- Dumping structure for view wikidatabase.get_articals
-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `get_articals`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `get_articals` AS SELECT
	*
FROM
	articals ;

-- Dumping structure for view wikidatabase.get_categories
-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `get_categories`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `get_categories` AS SELECT
	*
FROM
	categories ;

-- Dumping structure for view wikidatabase.get_sections
-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `get_sections`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `get_sections` AS SELECT
	*
FROM
	artical_sections ;

-- Dumping structure for view wikidatabase.get_topics
-- Removing temporary table and create final VIEW structure
DROP TABLE IF EXISTS `get_topics`;
CREATE ALGORITHM=UNDEFINED SQL SECURITY DEFINER VIEW `get_topics` AS SELECT
	*
FROM
	topics ;

/*!40103 SET TIME_ZONE=IFNULL(@OLD_TIME_ZONE, 'system') */;
/*!40101 SET SQL_MODE=IFNULL(@OLD_SQL_MODE, '') */;
/*!40014 SET FOREIGN_KEY_CHECKS=IFNULL(@OLD_FOREIGN_KEY_CHECKS, 1) */;
/*!40101 SET CHARACTER_SET_CLIENT=@OLD_CHARACTER_SET_CLIENT */;
/*!40111 SET SQL_NOTES=IFNULL(@OLD_SQL_NOTES, 1) */;
